function [latencies latencyMean latencySD amplitudes amplitudeMean amplitudeSD] = ...
    getImagingLatencyAmplitude(total, numFrames, frameRate)

secPerFrame = 1 / frameRate;

nworms = size(total,2);
latencies = zeros(1, nworms);
amplitudes = zeros(1, nworms);

for i=1:nworms
    datum = total(:,i);
    k = find(datum >= 0.2, 1);  % Count latency from time when signal goes above 20%
    if(~isempty(k))
        latencies(i) = (k-1) * secPerFrame;
    else
        latencies(i) = numFrames * secPerFrame;  % Maximum latency if it never responds
    end
    amplitudes(i) = max(datum);
end

latencyMean = mean(latencies);
latencySD = std(latencies);
amplitudeMean = mean(amplitudes);
amplitudeSD = std(amplitudes);

end